﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Domaine;
using Persistance;

namespace Test
{
    /// <summary>
    /// Classe d'accès aux données basée sur des données de test internes
    /// </summary>
    public class AccesDonneesTest : AccesDonnees
    {
        List<Utilisateur> utilisateurs;
        List<Livre> livres;
        List<Emprunt> emprunts;

        /// <summary>
        /// Constructeur
        /// </summary>
        public AccesDonneesTest()
        {
            // instanciation et initialisation de la liste des utilisateurs de test
            utilisateurs = new List<Utilisateur>();
            utilisateurs.Add(new Utilisateur(1, "Neymar", "Jean"));
            utilisateurs.Add(new Utilisateur(2, "Bou", "Carrie"));
            utilisateurs.Add(new Utilisateur(3, "Rogne", "Olive"));

            // instanciation et initialisation de la liste des livres de test
            livres = new List<Livre>();
            livres.Add(new Livre("978-2070368228", "1984", "Georges Orwell"));
            livres.Add(new Livre("978-2743615871", "Le Dahlia Noir", "James Ellroy"));
            livres.Add(new Livre("978-2743602680", "LA Confidential", "James Ellroy"));
            livres.Add(new Livre("978-2266149846", "Le Désert des Tartares", "Dino Buzzati"));

            // instanciation et initialisation de la liste des emprunts de test
            emprunts = new List<Emprunt>();
            Emprunt emprunt = new Emprunt(utilisateurs[0], livres[1]);
            emprunt.Rendu = true;
            emprunts.Add(emprunt);
            emprunt = new Emprunt(utilisateurs[0], livres[2]);
            emprunts.Add(emprunt);
            emprunt = new Emprunt(utilisateurs[2], livres[1]);
            emprunts.Add(emprunt);
        }

        public override List<Utilisateur> GetUtilisateurs()
        {
            return utilisateurs;
        }

        public override List<Livre> GetLivres()
        {
            return livres;
        }

        public override List<Livre> GetLivresEmpruntables()
        {
            List<string> isbnLivresEmpruntes = new List<string>();
            foreach (Emprunt emprunt in GetEmprunts())
                if (!emprunt.Rendu)
                    isbnLivresEmpruntes.Add(emprunt.Livre.Isbn);

            List<Livre> livresEmpruntables = new List<Livre>();
            foreach (Livre livre in GetLivres())
                if (!isbnLivresEmpruntes.Contains(livre.Isbn))
                    livresEmpruntables.Add(livre);

            return livresEmpruntables;
        }

        public override List<Emprunt> GetEmprunts()
        {
            return emprunts;
        }

        public override List<Emprunt> GetEmpruntsNonRendus()
        {
            List<Emprunt> empruntsNonRendus = new List<Emprunt>();
            foreach (Emprunt emprunt in emprunts)
                if (!emprunt.Rendu)
                    empruntsNonRendus.Add(emprunt);

            return empruntsNonRendus;
        }

        public override void Ajouter(Emprunt emprunt)
        {
            emprunts.Add(emprunt);
        }

        public override void EnregistrerRetour(Emprunt emprunt)
        {
            // rien à faire ici : l'instance passée en paramètre est déjà modifiée
        }

        public override void EnregistrerUtilisateur(Utilisateur utilisateur)
        {
            if ((utilisateur.Nom.Length == 0) || (utilisateur.Prenom.Length == 0))
                throw new Exception("concernant l'utilisateur");

            utilisateurs.Add(new Utilisateur(4, utilisateur.Nom, utilisateur.Prenom));
        }

        public override void EnregistrerLivre(Livre livre)
        {
            if ((livre.Isbn.Length == 0) || (livre.Titre.Length == 0) || (livre.Auteur.Length == 0))
                throw new Exception("concernant le livre");

            livres.Add(new Livre(livre.Isbn, livre.Titre, livre.Auteur));
        }
    }
}
